#include "CommunicationReceiver.h"
#define _MULTI_THREADED
#include <pthread.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <stddef.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <unistd.h>
#include <fcntl.h>
#include <iostream>
namespace Communication
{
CommunicationReceiver::CommunicationReceiver()
{
	decoder = new CommunicationDecoder();
}

CommunicationReceiver::~CommunicationReceiver()
{
	this->FreeResources();
	delete decoder;
}

void *ThreadStartup(void *_tgtObject) 
{
	CommunicationReceiver *tgtObject = (CommunicationReceiver *)_tgtObject;
	void *threadResult = tgtObject->run();	
	delete tgtObject;
	return threadResult;
}


void CommunicationReceiver::FreeResources()
{
	decoder->FreeResources();
	close(receivesocket);
}

void *CommunicationReceiver::run(void)
{
	ConfigurationServer* config = ConfigurationServer::GetInstance(); 
	int length;
	struct sockaddr_in receivename;
	receivename.sin_family = AF_INET;
	receivename.sin_port = htons(config->GetCommunicationReceiverPort());
	receivename.sin_addr.s_addr =htonl(INADDR_ANY);
	
	receivesocket = socket(AF_INET, SOCK_DGRAM, 0);
	int maximumdatagramsize = config->GetMaximumDatagramSize();
	length = sizeof(receivename);
	if (bind(receivesocket,(struct sockaddr *)&receivename,length))
		printf("Warning: Bind Error\n");

	if (getsockname(receivesocket,(struct sockaddr *)&receivename,(socklen_t *)&length))
		printf("Warning: Name Error\n");
	char buffer[maximumdatagramsize];
	
	//fcntl(sock,F_SETFL, O_NONBLOCK);

	while (1)
	{
		int resp = read(receivesocket,buffer,maximumdatagramsize); 
		if (resp!=-1)
		{		
			buffer[resp]='\0';
			char *auxptr = 0;
			
			//Optimizacion, va en contra dela modularidad, pero bueh,,,,WorldBroadcastSync
			auxptr = strstr(buffer,"<WorldBroadcastSync");
			bool broadcast= false;
			bool sync = false;
			if (auxptr!=0)
			{
				broadcast = true;
				sync = true;
			}
			else
			{
				auxptr = strstr(buffer,"<WorldBroadcast");
							
				if (auxptr!=0)
				{
					broadcast=true;				
				}
			}
			
			string todecode = buffer;
			
			decoder->ProcessMessage(todecode, broadcast, sync);
			
			//cout<< "Fowarded message in Communication Receiver:"<<todecode.data()<<endl; 
		}
			
	}
}
}
